/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier.Contributors;

import com.hoshino.cti.util.CtiTagkey;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class Mz
extends Modifier
implements BlockBreakModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook,
ProcessLootModifierHook,
InventoryTickModifierHook {
    public static final ResourceLocation MZBreak = new ResourceLocation("mz_break");
    public static final ResourceLocation CurrentMZ = new ResourceLocation("current_mz");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.BLOCK_BREAK, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP, ModifierHooks.PROCESS_LOOT, ModifierHooks.INVENTORY_TICK});
    }

    public static int miZiPoint(IToolStackView view, int modifierLevel) {
        int amount = view.getPersistentData().getInt(MZBreak);
        if (amount == 0) {
            return 1;
        }
        int count = 0;
        for (int n = Math.abs(amount); n > 0; n /= 10) {
            ++count;
        }
        return count * modifierLevel;
    }

    public void afterBlockBreak(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolHarvestContext toolHarvestContext) {
        int amount = iToolStackView.getPersistentData().getInt(MZBreak);
        if (toolHarvestContext.getPlayer() instanceof FakePlayer) {
            return;
        }
        if (iToolStackView.hasTag(TinkerTags.Items.HARVEST)) {
            iToolStackView.getPersistentData().putInt(MZBreak, amount + 1);
        }
    }

    public float getMeleeDamage(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolAttackContext toolAttackContext, float v, float v1) {
        int miziPoint = Mz.miZiPoint(iToolStackView, modifierEntry.getLevel());
        return v1 * (float)Math.round(Math.sqrt(miziPoint));
    }

    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        int amount = iToolStackView.getPersistentData().getInt(MZBreak);
        list.add((Component)Component.m_237113_((String)("\u5f53\u524d\u603b\u6316\u6398\u65b9\u5757\u6570" + amount)));
        list.add((Component)Component.m_237113_((String)("\u5f53\u524d\u8ff7\u5b50\u70b9\u6570" + Mz.miZiPoint(iToolStackView, modifierEntry.getLevel()))));
        list.add((Component)Component.m_237113_((String)("\u5f53\u524d\u5269\u4f59\u514d\u6b7b\u70b9\u6570" + iToolStackView.getPersistentData().getInt(CurrentMZ))));
    }

    public void processLoot(IToolStackView iToolStackView, ModifierEntry modifierEntry, List<ItemStack> list, LootContext lootContext) {
        if (!iToolStackView.getStats().hasStat((IToolStat)ToolStats.HARVEST_TIER)) {
            return;
        }
        BlockState targetBlock = (BlockState)lootContext.m_78953_(LootContextParams.f_81461_);
        if (targetBlock == null || targetBlock.m_60795_()) {
            return;
        }
        boolean applyMultiplier = false;
        Block block = targetBlock.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            applyMultiplier = cropBlock.m_52307_(targetBlock);
        } else if (targetBlock.m_204336_(CtiTagkey.ORE)) {
            applyMultiplier = true;
        }
        if (applyMultiplier) {
            int mizi = Mz.miZiPoint(iToolStackView, modifierEntry.getLevel());
            for (ItemStack stack : list) {
                if (stack.m_150930_(targetBlock.m_60734_().m_5456_())) continue;
                stack.m_41764_(mizi * stack.m_41613_());
            }
        }
    }

    public void onInventoryTick(IToolStackView iToolStackView, ModifierEntry modifierEntry, Level level, LivingEntity livingEntity, int i, boolean b, boolean b1, ItemStack itemStack) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int mizi = Mz.miZiPoint(iToolStackView, modifierEntry.getLevel());
        if (player.f_19853_.m_46467_() % 24000L == 0L) {
            iToolStackView.getPersistentData().putInt(CurrentMZ, mizi);
        }
    }
}

